/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;

public final class RbfHandleResponse
implements Persistable {
    private RbfRequestId requestId = null;
    private MachineId origin = null;
    private boolean validRequest = true;
    private boolean success = false;
    private boolean redrive = true;
    private Object details = null;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$Persistable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$PersistentData;

    public RbfHandleResponse(RbfRequest request) {
        this(request.getIdentifier());
    }

    public RbfHandleResponse(RbfRequestId requestId) {
        this.requestId = requestId;
        this.origin = FcsServer.getFcsServer().getLocalMachineId();
    }

    public RbfHandleResponse(PersistentData data) throws PersistenceException {
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        Persistent persistent = (Persistent)data;
        int rbfVersion = persistent.rbfVersion;
        this.requestId = persistent.requestId;
        this.origin = persistent.origin;
        this.validRequest = persistent.validRequest;
        this.success = persistent.success;
        this.redrive = persistent.redrive;
        this.details = persistent.details == null ? null : pm.containedFormToObject(persistent.details);
    }

    public PersistentData getPersistentData() {
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        Persistent persistent = new Persistent();
        persistent.rbfVersion = 2;
        persistent.requestId = this.requestId;
        persistent.origin = this.origin;
        persistent.validRequest = this.validRequest;
        persistent.success = this.success;
        persistent.redrive = this.redrive;
        persistent.details = this.details == null ? null : pm.objectToContainedForm(this.details);
        return persistent;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public RbfRequestId getRequestId() {
        return this.requestId;
    }

    public MachineId getOrigin() {
        return this.origin;
    }

    public void setValidRequest(boolean value) {
        this.validRequest = value;
        if (!this.validRequest) {
            this.success = false;
            this.redrive = false;
        }
    }

    public boolean isValidRequest() {
        return this.validRequest;
    }

    public void setSuccess(boolean value) {
        this.success = value;
        if (this.success) {
            this.redrive = false;
        }
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setRedrive(boolean value) {
        this.redrive = value;
    }

    public boolean isRedrivable() {
        return this.redrive;
    }

    public void setDetails(Object details) throws IllegalArgumentException {
        if (!(details == null || (class$java$io$Serializable == null ? (class$java$io$Serializable = RbfHandleResponse.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(details.getClass()) || (class$com$ibm$hwmca$fw$persist$Persistable == null ? (class$com$ibm$hwmca$fw$persist$Persistable = RbfHandleResponse.class$("com.ibm.hwmca.fw.persist.Persistable")) : class$com$ibm$hwmca$fw$persist$Persistable).isAssignableFrom(details.getClass()) || (class$com$ibm$hwmca$fw$persist$PersistentData == null ? (class$com$ibm$hwmca$fw$persist$PersistentData = RbfHandleResponse.class$("com.ibm.hwmca.fw.persist.PersistentData")) : class$com$ibm$hwmca$fw$persist$PersistentData).isAssignableFrom(details.getClass()))) {
            String msg = "The details object does not implement either java.io.Serializable, com.ibm.hwmca.fw.persist.Persistable, or com.ibm.hwmca.fw.persist.PersistentData";
            throw new IllegalArgumentException(msg);
        }
        this.details = details;
    }

    public Object getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RbfHandleResponse:\n");
        sb.append("requestId=" + this.requestId + "\n");
        sb.append("origin=" + RbfUtils.getMachineInfo(this.origin) + "\n");
        sb.append("validReq=" + this.validRequest + "\n");
        sb.append("success=" + this.success + "\n");
        sb.append("redrive=" + this.redrive + "\n");
        if (this.details == null) {
            sb.append("details=null");
        } else {
            sb.append("details=" + this.details.getClass().getName());
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -8773758739695407699L;
        int rbfVersion;
        RbfRequestId requestId;
        MachineId origin;
        boolean validRequest;
        boolean success;
        boolean redrive;
        Object details;

        private Persistent() {
        }
    }
}

